

OPTIONS DATE;
***** SET PATH NAME AS APPROPRIATE FOR YOUR COMPUTER; 
FILENAME USPS 'C:\USO\RURAL07\RMC06\FY2006.RMCforPRC.DAT';
LIBNAME IN 'C:\USO\RURAL07\RMC06\';
LIBNAME OUT 'C:\USO\RURAL07\RMC06';

****************** RMC_06_RETAIL_TRZ31.53.SAS ***************;
***  CALCULATES TIME & COST PER RURAL RETAIL TRANSACTION       ***;
***  PER DAY PER ROUTE  									   ***;
***  INPUT FLAT TEXT FILE 'FY2006.RMCforPRC.DAT' WITH DATA FROM 
***  2006 RURAL MAIL COUNT (RMC)                               ***;
******************* RMC_06_RETAIL_TRZ31.53.SAS****************;

***************************************************************************************;
***  This part of the program converts the flat file {FY2006.RMCforPRC.DAT} which   ***;
***  contains the 2006 Rural Carrier National Mail Count data, into a SAS data set  ***;
***************************************************************************************;
/*  Variables describing the route and the route evaluation

RTTYPE	Route type: H, J, K (Evaluated), or A, M (Other)
MILES	Number of miles on the route
BOXESR	Number of regular mailboxes on the route 
BOXESC	Number of centralized mailboxes on the route
NDCBU	Neighborhood Delivery and Collection Box Units
PARLOCK	Parcel post lockers 

Counts of each item during mail count. Used to calculate average weekly pieces

LETTERS	Number of letters delivered 
FLATS	Number of flats delivered  
PARCELS	Number of parcels delivered     
BOXHOLD	Number of boxholder pieces delivered    
REGCERT	Number of registered, certified, etc. delivered
CODCUST	Number of C.O.D. and customs due   
CHGADDR	Number of change of address forms  
MARKUP	Number of markups (undeliverable mail)  
F3579	Number of forms 3579 and 3821 filled out  
DPS	    Number of dps pieces delivered     
SECSEG	Number of sector segment pieces delivered   
MONORDR	Number of money orders        
LETCOLL	Number of letter size pieces collected 
PARCACC	Number of parcel posts accepted  
REGACC	Number of registrd, cert., collected on route
POSTDUE	Number of postage dues   
LOADING	Loading vehicle       
ALLOW	Other suitable allowance count  = del conf scans 
DSMOUNT	Number of authorized dismounts      
DSMFEET	Dismount distance walked (feet) 
PURCHST	Purchase stamp count    
RETRCT	Number of return receipts 
POUCHST	Lock pouch stops     

Variables showing evaluated time allowances

DLLETRT	Time delivering letters 
DLFLATT	Time delivering flats   
DLPAROT	Time delivering parcels (office)   
DLPARRT	Time delivering parcels (route)  
WITHDT	Time withdrawing mail  
STRAPT	Time strap out (bands on lets/flats) to keep seq
LOADNGT	Time loading vehicle
RETRCTT	Time handling return receipts 
DISMNTT	Time for dismounts  
BOXHLDT	Time delivering boxholder mail   
CODCSOT	Time for C.O.D. and customs due, office   
DLREGOT	Time deliver registrd, certifd, office time  
MARKUPT	Time for Markups (undeliverable mail) 
ADDREST	Time for change of address forms   
MNORDOT	Time for Money orders, office time  
COLLFT	Time collecting letter size pieces  
PPACCOT	Time accepting parcel posts, office time   
STAMPST	Purchasing stamps for the route 
F3579T	Time filling out forms 3579 and 3821
ALLOWT	Other suitable allowances = del con scan time 
POSTDUT	Time for postage due 
PERSNLT	Time office work not in personal time  
CODCSRT	Time for C.O.D. and customs due, route time
DLREGRT	Time for Deliver registrd, certif, route time
MNORDRT	Time for Money orders, route time 
PPACCRT	Time for parcel posts accepted, route time  
COLREGT	Collecting registered, certified, etc. 
MILEST	Miles driven on the route  
BOXESRT	Number of regular boxes
BOXESCT	Number of centralized boxes
NDCBUT	Neighborhood Delivery and Collection Box Units
PARLCKT	Parcel post lockers 
POUCHT	Locked pouch delivery 
SECSEGT	Delivery of Sector Segment Pieces 
DPST	Time for DPS letter delilvery  
GOVVEHT	Time for loading/unloading Government Vehicles
REUNLDT	Time for reloading/Unloading 

TOTHRS	Total hours on the route 
TOTMIN	Minutes on the route   
ACTLHRS	Average weekly actual hours 
YEAR	Fiscal year the evaluation was taken */
*************************************************;
*****READ IN UNIVERSE DATA;                                       
DATA R1;
INFILE USPS LRECL=685 ; 
INPUT                                            
RTTYPE $ 1-5                                                          
 MILES  6-10                                                           
 BOXESR 11-20                                                          
 BOXESC 21-30                                                          
 NDCBU  31-40                                                          
 PARLOCK 41-50                                                         
 LETTERS 51-60                                                         
 FLATS   61-70                                                         
 PARCELS 71-80                                                         
 BOXHOLD 81-90                                                         
 REGCERT 91-100                                                        
 CODCUST 101-110                                                       
 CHGADDR 111-120                                                       
 MARKUP  121-130                                                       
 F3579   131-140                                                       
 DPS     141-150                                                       
 SECSEG  151-160                                                       
 MONORDR 161-170                                                       
 LETCOLL 171-180                                                       
 PARCACC 181-190                                                       
 REGACC  191-200                                                       
 POSTDUE 201-210                                                       
 LOADING 211-220                                                       
 ALLOW   221-230                                                       
 DSMOUNT 231-240                                                       
 DSMFEET 241-250                                                       
 PURCHST 251-260                                                       
 RETRCT  261-270                                                       
 POUCHST 271-280                                                       
 DLLETRT 281-290                                                       
 DLFLATT 291-300                                                       
 DLPAROT 301-310                                                       
 DLPARRT 311-320                                                       
 WITHDT  321-330                                                       
 STRAPT  331-340                                                       
 LOADNGT 341-350                                                       
 RETRCTT 351-360                                                       
 DISMNTT 361-370                                                       
 BOXHLDT 371-380                                                       
 CODCSOT 381-390                                                       
 DLREGOT 391-400                                                       
 MARKUPT 401-410                                                       
 ADDREST 411-420                                                       
 MNORDOT 421-430                                                       
 COLLFT  431-440                                                       
 PPACCOT 441-450                                                       
 STAMPST 451-460                                                       
 F3579T  461-470                                                       
 ALLOWT  471-480                                                       
 POSTDUT 481-490                                                       
 PERSNLT 491-500                                                       
 CODCSRT 501-510                                                       
 DLREGRT 511-520                                                       
 MNORDRT 521-530                                                       
 PPACCRT 531-540                                                       
 COLREGT 541-550                                                       
 MILEST  551-560                                                       
 BOXESRT 561-570                                                       
 BOXESCT 571-580                                                       
 NDCBUT  581-590                                                       
 PARLCKT 591-600                                                       
 POUCHT  601-610                                                       
 SECSEGT 611-620                                                       
 DPST    621-630                                                       
 GOVVEHT 631-640                                                       
 REUNLDT 641-650                                                       
 TOTHRS  651-660                                                       
 TOTMIN  661-670                                                       
 ACTLHRS 671-680                                                       
 YEAR    681-685;

*********************  CNTLEN IS NUMBER OF WEEKS IN RMC THAT YEAR.  *****;
****************        USED TO GET VOLUMES AND TIMES PER WEEK      ****;

DATA R2;
  SET R1;

  IF YEAR = 2002 THEN CNTLEN = 2;                                        
ELSE IF YEAR = 2003 THEN CNTLEN = 4;                                   
ELSE IF YEAR = 2004 THEN CNTLEN = 3;                                   
ELSE IF YEAR = 2005 THEN CNTLEN = 4;
ELSE IF YEAR = 2006 THEN CNTLEN = 2;                                   
OUTPUT;
****************************************************************
***** GLOBAL EDITING OF DATA(FY 2006 USPS SAS Program) **********
****************************************************************;
DATA R3;
  SET R2;

IF MILES > .05;
IF LETTERS > 0;
RUN;
 
DATA R4;
  SET R3;
TBOXES = BOXESR + BOXESC;
BX_MILE = TBOXES/MILES;
DENSITY = 'NL';
IF (BX_MILE) >= 12 THEN DENSITY = 'L'; *CREATES THE VARIABLE 'DENSITY'; 
RUN;
DATA R5;
  SET R4;
IF RTTYPE = 'H' OR RTTYPE = 'J' OR RTTYPE = 'K' THEN TYPE = 'EVAL';    
ELSE IF RTTYPE = 'A' OR RTTYPE = 'M' THEN TYPE = 'OTHR';               
ELSE DELETE; 
RUN;
***************************************************************
* VARIABLE SPECIFIC EDITING OF DATA (FY 2006 USPS SAS Program)*
***************************************************************; 
DATA R6;
  SET R5;

IF LOADNGT > 90 THEN LOADNGT = 90;                                     

IF DENSITY = 'L' THEN STAMPST=STAMPST; 
ELSE STAMPST=30;
 
IF PPACCRT = 0 THEN PPACCRT = PPACCOT;
***********************************************************
******* WEEKLY VALUES (FY 2006 USPS SAS Program) **********
***********************************************************;
*DEVELOPS WEEKLY DATA;
LETTERS=LETTERS/CNTLEN; FLATS=FLATS/CNTLEN; PARCELS=PARCELS/CNTLEN;
BOXHOLD=BOXHOLD/CNTLEN; REGCERT=REGCERT/CNTLEN; CODCUST=CODCUST/CNTLEN;
CHGADDR=CHGADDR/CNTLEN; MARKUP=MARKUP/CNTLEN; F3579=F3579/CNTLEN;
DPS=DPS/CNTLEN; SECSEG=SECSEG/CNTLEN; MONORDR=MONORDR/CNTLEN; 
LETCOLL=LETCOLL/CNTLEN;
PARCACC=PARCACC/CNTLEN; REGACC=REGACC/CNTLEN; POSTDUE=POSTDUE/CNTLEN;
LOADING=LOADING/CNTLEN; DSMOUNT=DSMOUNT/CNTLEN; 
DSMFEET=DSMFEET/CNTLEN; RETRCT=RETRCT/CNTLEN;

***********************************************************;
EVMNO=DLLETRT+DLFLATT+DLPAROT+WITHDT+STRAPT+LOADNGT+RETRCTT+
      BOXHLDT+CODCSOT+DLREGOT+MARKUPT+ADDREST+MNORDOT+PPACCOT+
      STAMPST+F3579T+ALLOWT+POSTDUT+PERSNLT+SECSEGT+DPST+GOVVEHT+REUNLDT;

EVMNR=DLPARRT+DISMNTT+COLLFT+CODCSRT+DLREGRT+MNORDRT+PPACCRT+COLREGT+
      MILEST+BOXESRT+BOXESCT+NDCBUT+PARLCKT+POUCHT;

TEVMN=EVMNO+EVMNR; *CALCULATES TOTAL EVALUATED TIME.;  

EVHRSO=EVMNO/60;
EVHRSR=EVMNR/60;
TEVHRS=TEVMN/60;

TPCS=LETTERS+FLATS+PARCELS+BOXHOLD+DPS+SECSEG+POSTDUE;
***********************************************************
******** DAILY VALUES (FY 2006 USPS SAS Program) **********
***********************************************************;
DATA R7;
  SET R6;
*DEVELOPS DAILY DATA;
LETTERS=LETTERS/6; FLATS=FLATS/6; PARCELS=PARCELS/6;
BOXHOLD=BOXHOLD/6; REGCERT=REGCERT/6; CODCUST=CODCUST/6;
CHGADDR=CHGADDR/6; MARKUP=MARKUP/6; F3579=F3579/6;
DPS=DPS/6; SECSEG=SECSEG/6; MONORDR=MONORDR/6; 
LETCOLL=LETCOLL/6;
PARCACC=PARCACC/6; REGACC=REGACC/6; POSTDUE=POSTDUE/6;
LOADING=LOADING/6; DSMOUNT=DSMOUNT/6; 
DSMFEET=DSMFEET/6; RETRCT=RETRCT/6;
TPCS=TPCS/6;

DLLETRT=DLLETRT/6; DLFLATT=DLFLATT/6; DLPAROT=DLPAROT/6; 
WITHDT=WITHDT/6; STRAPT=STRAPT/6; LOADNGT=LOADNGT/6;
RETRCTT=RETRCTT/6; BOXHLDT=BOXHLDT/6; CODCSOT=CODCSOT/6;
DLREGOT=DLREGOT/6; MARKUPT=MARKUPT/6; ADDREST=ADDREST/6;
MNORDOT=MNORDOT/6; PPACCOT=PPACCOT/6; 
STAMPST=STAMPST/6; F3579T=F3579T/6; ALLOWT=ALLOWT/6;  
POSTDUT=POSTDUT/6; PERSNLT=PERSNLT/6; SECSEGT=SECSEGT/6;
DPST=DPST/6; GOVVEHT=GOVVEHT/6; REUNLDT=REUNLDT/6;
DLPARRT=DLPARRT/6; DISMNTT=DISMNTT/6; COLLFT=COLLFT/6;
PPACCRT=PPACCRT/6; COLREGT=COLREGT/6; 
CODCSRT=CODCSRT/6; DLREGRT=DLREGRT/6; MNORDRT=MNORDRT/6; 
MILEST=MILEST/6; BOXESRT=BOXESRT/6; BOXESCT=BOXESCT/6;
NDCBUT=NDCBUT/6; PARLCKT=PARLCKT/6; POUCHT=POUCHT/6;

TOTHRS=TOTHRS/6; TOTMIN=TOTMIN/6; ACTLHRS=ACTLHRS/6;
EVMNO=EVMNO/6; EVMNR=EVMNR/6; TEVMN=TEVMN/6;
EVHRSO=EVHRSO/6; EVHRSR=EVHRSR/6; TEVHRS=TEVHRS/6;

***CALCULATE PIECES PER BOX PER DAY***;

 TPCS_BX = TPCS/TBOXES;

***SPLIT TIMES BETWEEN FIXED AND VARIABLE;
 
F3579TF = MIN(F3579T,12.);                                             
F3579TV = F3579T - F3579TF;

LOADTF = LOADNGT * .5;                                                 
LOADTV = LOADNGT * .5; 
 
STAMPTV = 0;
STAMPTF = 0;
IF DENSITY='L' THEN STAMPTV=STAMPST; 
ELSE STAMPTF=STAMPST;
 
FIXEDT= MILEST+BOXESRT+BOXESCT+NDCBUT+PARLCKT+POUCHT+         
        WITHDT+ADDREST+F3579TF+LOADTF+PERSNLT+STAMPTF+         
        ALLOWT+DISMNTT+GOVVEHT+REUNLDT;                            
                                                                       
VARIABLET= DLLETRT+DLFLATT+DLPAROT+DLPARRT+BOXHLDT+CODCSOT+CODCSRT+   
           DLREGOT+DLREGRT+MARKUPT+F3579TV+STRAPT+LOADTV+         
           MNORDOT+MNORDRT+COLLFT+PPACCOT+PPACCRT+COLREGT+        
           POSTDUT+STAMPTV+RETRCTT+DPST+SECSEGT;                  
                                                                       
TOTALT = FIXEDT + VARIABLET; 
VARIABILITY= VARIABLET / TOTALT;
************************************************************
*CALCULATION OF DAILY EQUIPMENT MAINTENANCE ALLOWANCE (EMA)*
************************************************************
*NOTE:ON JANUARY 7, 2006 (PAY PERIOD 02-06), THE RURAL CARRIER
*     DAILY EMA WAS SET AT 48.5 CENTS PER MILE OR A MINIMUM 
*     OF $19.40 PER DAY, WHICHEVER IS GREATER.
************************************************************;
EMA=0;
IF GOVVEHT=0 THEN DO;
EMA=MILES*0.485;
IF EMA<19.40 THEN EMA=19.40;
END;
* DEVELOPMENT OF DAYLY RURAL DELIVERY COST PER ROUTE *;
LC_H=31.531170;    *RURAL CARRIER LABOR COST PER EVALUATED HOUR*;
                   
PGBFCTR=1.24296775;  *RURAL CARRIER PIGGYBACK FACTOR FOR SURERVISION,
                      SPACE AND SPACE RELATED COSTS FROM ACR2007-1*;
                      
LC_R   =TEVHRS*LC_H;      *LABOR COST PER RURAL ROUTE*;
OHLC_R =LC_R*(PGBFCTR-1); *RURAL CARRIER OVERHEAD COST PER ROUTE*;
DC_R   =LC_R+OHLC_R+EMA;  *DELIVERY COST PER ROUTE*;
VDC_R  =DC_R*VARIABILITY; *VARIABLE DELIVERY COST PER ROUTE*;
FDC_R  =DC_R-VDC_R;       *FIXED DELIVERY COST PER ROUTE*;

EVMNO_PCS=EVMNO/TPCS;
EVMNR_PCS=EVMNR/TPCS;
TEVMN_PCS=TEVMN/TPCS;
DC_PCS   =DC_R/TPCS;

RETAIN SEQ 1;
IF SEQ < 73145 THEN DO; *73,144=NUMBER OF ROUTES IN RMC FY 2006*;
OUTPUT;
SEQ = SEQ+1;
END;
RUN;

******************* RMC_06_RETAIL_TRZ31.53.SAS ***************;
***  CALCULATES TIME & COST PER RURAL RETAIL TRANSACTION       ***;
***  PER DAY PER ROUTE  									   ***;
***  INPUTS THE FULL DAILY DATASET FROM RMC_O6.SAS             ***;
******************* RMC_06_RETAIL_TRZ31.53.SAS****************;

DATA RETAIL1;
SET R7; 
RUN;  

*******  PERFORMS NEEDED CALCULATIONS  **********;
DATA RETAIL2;
	SET RETAIL1;

/*  Variables describing the number of retail transactions

	MONORDR	Number of money orders
	LETCOLL	Number of letter size pieces collected
	PARCACC	Number of parcel posts accepted  
	REGACC	Number of registrd, cert., collected on route
	RETRCT	Number of return receipts*/

	*TOTAL DAILY RETAIL TRANSACTIONS PER ROUTE ***;
RETAILTRZ = MONORDR+LETCOLL+PARCACC+REGACC+RETRCT;

IF RETAILTRZ=0 THEN RETAILTRZ=1;  *TO PREVENT DIVIDING BY ZERO*;

/*  Variables describing office time on retail transactions

	RETRCTT	Time handling return receipts 
	MNORDOT	Time for Money orders, office time  
	PPACCOT	Time accepting parcel posts, office time   
	STAMPST	Purchasing stamps for the route
	ALLOWT	Other suitable allowances*/
	
** RETAIL DAILY OFFICE MINUTES PER ROUTE ***;            

EVMNORTL = RETRCTT+MNORDOT+PPACCOT+STAMPST+ALLOWT;

/*  Variables describing street time on retail transactions

	DISMNTT	Time for dismounts
	COLLFT	Time collecting letter size pieces  
	MNORDRT	Time for Money orders, route time 
	PPACCRT	Time for parcel posts accepted, route time  
	COLREGT	Collecting registered, certified, etc.*/  

***RETAIL DAILY STREET MINUTES PER ROUTE ***;

EVMNRRTL = DISMNTT+COLLFT+MNORDRT+PPACCRT+COLREGT;

**TOTAL DAILY RETAIL MINUTES PER ROUTE ***;
TEVMNRTL=EVMNORTL+EVMNRRTL;

EVMNORTL_TRZ = EVMNORTL/RETAILTRZ;   *OFFICE RETAIL DAILY TIME(MINUTES)PER TRANSACTION*;
EVMNRRTL_TRZ = EVMNRRTL/RETAILTRZ;   *STREET RETAIL DAILY TIME(MINUTES)PER TRANSACTION*;
TEVMNRTL_TRZ = TEVMNRTL/RETAILTRZ;   *RETAIL DAILY TIME(MINUTES)PER TRANSACTION*;
RUN;

**  CALCULATE RETAIL DELIVERY COST ***;
DATA RETAIL3;
	SET RETAIL2;
	
LC_MIN=LC_H/60; *RURAL CARRIER LABOR COST PER EVALUATED MINUTE*;                

RETAILLC_R   =  TEVMNRTL*LC_MIN;         *RETAIL DIRECT LABOR COST PER RURAL ROUTE PER DAY*;
RETAILOHLC_R =  LC_MIN*(PGBFCTR-1);      *RURAL CARRIER OVERHEAD COST PER ROUTE PER DAY*;
RETAILDC_R   =  RETAILLC_R+RETAILOHLC_R; *TOTAL DELIVERY RETAIL COST PER ROUTE PER DAY*;
RETAILDC_TRZ =  RETAILDC_R/RETAILTRZ;    *RETAIL COST PER TRANSACTION PER DAY*;

RUN;
***     SUMMARIZE OUTPUT  ******;
DATA OUT.RETAIL_TRZ_RMC_06;
  SET RETAIL3;

TITLE1 'RETAIL VALUES PER ROUTE PER DAY';
TITLE2 '2006 RURAL CARRIER NATIONAL MAIL COUNT';

PROC MEANS MAXDEC=4 FW=14 DATA = OUT.RETAIL_TRZ_RMC_06;
TITLE1 'AVERAGES OF RURAL RETAIL VALUES';
TITLE2 'ALL ROUTES IN THE UNIVERSE';
RUN;

PROC MEANS MAXDEC=4 FW=14 DATA = OUT.RETAIL_TRZ_RMC_06;
VAR EVMNORTL_TRZ EVMNRRTL_TRZ TEVMNRTL_TRZ RETAILDC_TRZ;
WEIGHT RETAILTRZ;
TITLE1 'WEIGHTED AVERAGES OF RURAL RETAIL VALUES';
TITLE2 'WEIGHTED BY TRANSACTIONS';
TITLE3 'ALL ROUTES IN THE UNIVERSE';
RUN;
